package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CtWorkflowCommentDto;

public class CtWorkflowCommentDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "CT_WORKFLOW_COMMENT";
	public static final String KEY_1 	= "COMMENTID";	//RgID

	// 
	public static final String COL_COMMENT_ID  		= "COMMENTID"		;	//RgID
	public static final String COL_WORKFLOW  			= "WORKFLOW"		;	//[Nt[ԍ
	public static final String COL_KCODE  				= "KCODE"			;	//ЈR[h
	public static final String COL_TARGET  			= "TARGET"			;	//Ώێ
	public static final String COL_AUTHOR_COMMENT  	= "AUTHORCOMMENT"	;	//Rg
	public static final String COL_DELETE_FLAG  		= "DELETEFLAG"		;	//폜tO

	/**
	 * RXgN^
	 */
	public CtWorkflowCommentDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CtWorkflowCommentDto> mappingAll() throws SQLException {
		List<CtWorkflowCommentDto> all = new ArrayList<CtWorkflowCommentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return CtWorkFlowCommentDto ct_workflow_commentR[h
	 * @throws SQLException
	 */
	private CtWorkflowCommentDto mapping() throws SQLException {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		dto.setCommentId(		rs.getLong (COL_COMMENT_ID)			);	//RgID
		dto.setWorkflow(		rs.getLong (COL_WORKFLOW)			);	//[Nt[ԍ
		dto.setKCode(			rs.getString (COL_KCODE)			);	//ЈR[h
		dto.setTarget(			rs.getString (COL_TARGET)			);	//[UΏۃRg
		dto.setAuthorComment(	rs.getString (COL_AUTHOR_COMMENT)	);	//FґΏۃRg
		dto.setDeleteFlag(		rs.getInt(COL_DELETE_FLAG)			);	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtWorkflowCommentDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CtWorkflowCommentDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param coMMENTID RgID(L[)
	 * @param kcODE ЈR[h(L[)
	 * @return CtWorkFlowCommentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtWorkflowCommentDto findForKey(
			long  commentid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, commentid);
			executeQuery();
			CtWorkflowCommentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param coMMENTID RgID(L[)
	 * @param kcODE ЈR[h(L[)
	 * @return CtWorkFlowCommentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtWorkflowCommentDto findForUpdate(
			long commentid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, commentid);
			executeQuery();
			CtWorkflowCommentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param coMMENTID RgID
	 * @param kcODE ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtWorkflowCommentDto> findForCondition(
			long commentid,
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_COMMENT_ID);
		sb.append(" = ? AND ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   commentid  );
			setParam(index++,   kcode   + "%");
			executeQuery();
			List<CtWorkflowCommentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * @param workflow
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtWorkflowCommentDto> findForWorkFlow(
			long workflow
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_WORKFLOW);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   workflow  );
			executeQuery();
			List<CtWorkflowCommentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * @param target
	 * @param workflow
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtWorkflowCommentDto> findForWorkFlow(
			String target,
			long workflow
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_TARGET);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_WORKFLOW);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   target  );
			setParam(index++,   workflow  );
			executeQuery();
			List<CtWorkflowCommentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * @param target
	 * @param workflow
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtWorkflowCommentDto> findForTarget(
			String target,
			long workflow
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_TARGET);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_WORKFLOW);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + addDESC());
			setParam(index++,   target  );
			setParam(index++,   workflow  );
			executeQuery();
			List<CtWorkflowCommentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param target ΏێЈR[h
	 * @param workflow [Nt[ԍ
	 * @return CtWorkFlowCommentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtWorkflowCommentDto findForMaxTarget(
			String target,
			long workflow
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_TARGET);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_WORKFLOW);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + addDESCLimit1());
			setParam(index++,   target  );
			setParam(index++,   workflow  );
			executeQuery();
			CtWorkflowCommentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	

	/**
	 * ɂf[^擾
	 * @param target ΏێЈR[h
	 * @param workflow [Nt[ԍ
	 * @return CtWorkFlowCommentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtWorkflowCommentDto findForMaxApprover(
			String kcode,
			long workflow
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_WORKFLOW);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + addDESCLimit1());
			setParam(index++,   kcode  		);
			setParam(index++,   workflow  	);
			executeQuery();
			CtWorkflowCommentDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CtWorkflowCommentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CtWorkflowCommentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getCommentId());
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CtWorkflowCommentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getCommentId());
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxEno = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_COMMENT_ID);
			sb.append(") FROM ");
			sb.append(TABLE);
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				maxEno = String.valueOf(rs.getLong(1));
			}
			return maxEno;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(CtWorkflowCommentDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getCommentId());		//RgID
		setParam(index++, dto.getWorkflow());		//[Nt[ԍ
		setParam(index++, dto.getKCode());			//ЈR[h
		setParam(index++, dto.getTarget());			//Ώێ
		setParam(index++, dto.getAuthorComment());	//Rg
		setParam(index++, dto.getDeleteFlag());		//폜tO
		setCommonParams(isInsert);
	}

	private String addDESC() {
		return "DESC";
	}

	private String addDESCLimit1() {
		return "DESC LIMIT 1";
	}

}
